package cn.quantgroup.boot.micrometer.register.kafka;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ObjectUtils;

@Configuration
@ComponentScan(basePackageClasses = KafkaMeterRegistry.class)
@EnableConfigurationProperties(EnochAgentProperties.class)
@ConditionalOnProperty(prefix = "tech.metric", name = "enabled", havingValue = "true")
@DependsOn({"nacosServiceDiscovery"})
public class MicroMeterKafkaAutoConfiguration implements ApplicationContextAware {

  private final EnochAgentProperties enochAgentProperties;
  @Value("${spring.application.name}")
  private String applicationName;
  private ApplicationContext applicationContext;

  public MicroMeterKafkaAutoConfiguration(
      EnochAgentProperties enochAgentProperties) {
    this.enochAgentProperties = enochAgentProperties;
  }

  @Bean
  public KafkaConfig kafkaConfig() {
    return new
        KafkaConfig() {
          @Override
          public String get(String s) {
            return null;
          }

          @Override
          public String services() {
            return enochAgentProperties.getKafkaHost();
          }

          @Override
          public String topic() {
            return enochAgentProperties.getKafkaTopic();
          }

          @Override
          public String applicationName() {
            return applicationName;
          }
        };
  }

  @Bean
  @Primary
  public KafkaMeterRegistry kafkaMeterRegistry(KafkaConfig kafkaConfig) {
    //运行环境env，由于现有项目错误使用NAMESPACE，所以为了维持兼容采用这个参数
    String env;
    if (ObjectUtils.isEmpty(System.getProperty("NAMESPACE"))) {
      env = "default";
    } else {
      env = System.getProperty("NAMESPACE");
    }
    KafkaMeterRegistry kafkaMeterRegistry = new KafkaMeterRegistry(kafkaConfig, Clock.SYSTEM,
        this.applicationContext);
    kafkaMeterRegistry.config().commonTags(Arrays.asList(
        Tag.of("env", env), Tag.of("application", applicationName)));
    return kafkaMeterRegistry;
  }

  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    this.applicationContext = applicationContext;
  }
}
