package cn.quantgroup.xyqb.Utils;

import com.google.common.base.Stopwatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * 注意事项：
 * 1. 使用前在配置文件内配置 DATA_CENTER_ID
 *
 *
 * Created by zhiguo.liu on 2017/5/18.
 */
@Component
public class IDGenerator {


    private static final String REDIS_WORK_ID_KEY = "GLOBAL:WORK:ID:";
    private static final String ID_FORMAT = "yyyyMMddHHmmss";

    // data center，默认为 1
    private static int DATA_CENTER_ID = 1;
    private static int WORKER_ID = 0;
    // 最高支持同时1W台机器
    private static final int MAX_WORK_ID = 10000;
    // 最高每秒发号 100w
    private static final int MAX_COUNT = 999999;

    private static long COUNTER = 0L;
    private static long MAX_TIME_SECOND = 0L;

    // 当前时间戳字符串
    private static String CURRENT_TIME_STR;
    // Worker ID 字符串
    private static String WORKER_ID_STR;
    // data center 字符串
    private static String DATA_CENTER_STR;

    @Autowired
    private StringRedisTemplate redis;

    @Value("${data.center.id}")
    public static void setDataCenterId(int dataCenterId) {
        DATA_CENTER_ID = dataCenterId;
    }

    @PostConstruct
    public void init() {
        WORKER_ID = (int) (redis.opsForValue().increment(REDIS_WORK_ID_KEY + DATA_CENTER_ID, 1) % MAX_WORK_ID);

        WORKER_ID_STR = String.format("%04d", WORKER_ID);
        DATA_CENTER_STR = String.format("%03d", DATA_CENTER_ID);
    }


    /**
     * 1. 需要获取 dataCenterId 和 workeId
     */
    public synchronized static String getId(String prefix) {
        Date now = new Date();
        Long timeSecond = now.getTime() / 1000;
        if (timeSecond > MAX_TIME_SECOND) {
            MAX_TIME_SECOND = timeSecond;
            CURRENT_TIME_STR = new SimpleDateFormat(ID_FORMAT, Locale.SIMPLIFIED_CHINESE).format(now);
            COUNTER = 0;
        }

        // 达到计数器上上限，或时间回退时, 休眠半秒并重试
        if (COUNTER >= MAX_COUNT || timeSecond < MAX_TIME_SECOND) {
            try {
                Thread.sleep(500);
                return getId(prefix);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        return prefix + CURRENT_TIME_STR + DATA_CENTER_STR + WORKER_ID_STR + String.format("%06d", ++COUNTER);
    }

}
