package cn.quantgroup.tech.shutdown.service;

import lombok.extern.slf4j.Slf4j;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;

/**
 * @author ag
 */
@Slf4j
public class JettyShutdown implements Shutdown, JettyServerCustomizer {

    private volatile Server server;

    @Override
    public void shutdown(Integer delay) throws InterruptedException {
        StatisticsHandler handler = new StatisticsHandler();
        handler.setHandler(server.getHandler());
        server.setHandler(handler);
        server.setStopTimeout(delay);
        //todo stop at shutdown
        server.setStopAtShutdown(true);
    }

    @Override
    public void customize(Server server) {
        this.server = server;
    }
}
