package cn.quantgroup.tech.db;

import java.util.ArrayList;
import java.util.List;

/**
 * @author ag 额. 这是个....自己看吧
 */
class DynamicDataSourceContextHolder {

    private static final ThreadLocal<DSType> CONTEXT_HOLDER = new ThreadLocal<>();
    static List<DSType> dataSourceIds = new ArrayList<>();

    static void setDataSourceType(DSType dataSourceType) {
        CONTEXT_HOLDER.set(dataSourceType);
    }

    static DSType getDataSourceType() {
        return CONTEXT_HOLDER.get();
    }

    static void clearDataSourceType() {
        CONTEXT_HOLDER.remove();
    }

    /**
     * 判断指定DataSource当前是否存在
     */
    static boolean containsDataSource(DSType dataSourceId) {
        return dataSourceIds.contains(dataSourceId);
    }
}