package cn.quantgroup.tech.brave.service.impl;

import brave.context.slf4j.MDCScopeDecorator;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalCurrentTraceContext;
import cn.quantgroup.tech.brave.service.ITechExecutorServiceBuilder;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.ExecutorService;

/**
 * zipkin线程池追踪一致性
 * Date: 2020/1/6
 * Time: 下午4:52
 *
 * @author: yangrui
 */
@Slf4j
public class TechExecutorServiceBuilderTrace implements ITechExecutorServiceBuilder {
    @Override
    public ExecutorService buildExecutorService(ExecutorService executorService) {
        log.info("构建ExecutorServiceTrace");
        CurrentTraceContext mdcCurrentTraceContext = ThreadLocalCurrentTraceContext
                .newBuilder().addScopeDecorator(MDCScopeDecorator.get()).build();
        return mdcCurrentTraceContext.executorService(executorService);
    }

    /**
     * 针对非主流ExecutorService终极解决方案
     *
     * @param task
     * @return
     */
    @Override
    public Runnable wrap(Runnable task) {
        log.info("wrap Runnable 4 support trace");
        CurrentTraceContext mdcCurrentTraceContext = ThreadLocalCurrentTraceContext
                .newBuilder().addScopeDecorator(MDCScopeDecorator.get()).build();
        return mdcCurrentTraceContext.wrap(task);
    }
}
