package cn.quantgroup.tech.mq.mapper;

import cn.quantgroup.tech.mq.entity.KoalaRabbitmqMessage;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.time.LocalDate;

/**
 * <p>
 * 考拉消息补偿表 Mapper 接口
 * </p>
 *
 * @author rui
 * @since 2020-04-28
 */
public interface KoalaRabbitmqMessageMapperV1 extends BaseMapper<KoalaRabbitmqMessage> {

    @Update("update koala_rabbitmq_message set msg_status = #{msgStatus} where unique_id = #{uniqueId}")
    void updateMsgStatusByUniqueId(@Param("uniqueId") String uniqueId, @Param("msgStatus") Integer msgStatus);

    @Update("update koala_rabbitmq_message set consume_count = consume_count + 1 where unique_id = #{uniqueId}")
    void addConsumeCountByUniqueId(String uniqueId);

    @Select("select consume_count consumeCount, max_consume_count maxConsumeCount, routing_key routingKey from koala_rabbitmq_message where unique_id = #{unique_id} limit 1")
    KoalaRabbitmqMessage selectByUniqueId(String uniqueId);

    @Update("update koala_rabbitmq_message set msg_content = #{msgContent} where unique_id = #{uniqueId}")
    void updateMsgContentByUniqueId(@Param("uniqueId") String uniqueId, @Param("msgContent") String msgContent);

    @Delete("delete from koala_rabbitmq_message where msg_status = 1 and created_at < #{createdAt}")
    void deleteMsgStatusSuccessByCreatedAt(@Param("createdAt") LocalDate localDate);
}
