package cn.quantgroup.tech.brave.interceptor;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


@Slf4j
public abstract class RequestInterceptor {
    @Data
    static class AuthInfoInMemory {
        private static List<String> hosts = new ArrayList<>();
        private static long expiration;
    }

    protected static final String AUTH = "quant-auth";
    // 内网
    @Value("#{'${quant.auth.http}'.split(',')}")
    List<String> authHttpList;

    protected boolean auth(String host) {
        if (authHttpList == null || authHttpList.isEmpty()) {
            return false;
        }
        if(AuthInfoInMemory.hosts.isEmpty() || System.currentTimeMillis() > AuthInfoInMemory.expiration){
            hostsCache();
        }
        return AuthInfoInMemory.hosts.contains(host);
    }

    private void hostsCache() {
        AuthInfoInMemory.hosts = authHttpList.stream()
                .map(RequestInterceptor::apply)
                .filter(Optional::isPresent)
                .map(Optional::get)
                .map(URL::getHost)
                .collect(Collectors.toList());
        AuthInfoInMemory.expiration = System.currentTimeMillis() + 30 * 60 * 60 * 1000;
    }

    private static Optional<URL> apply(String http) {
        URL url = null;
        try {
            url = new URL(http);
        } catch (MalformedURLException e) {
            log.error("无效quant.auth.http = 【{}】", http);
        }
        return Optional.ofNullable(url);
    }
}
