package cn.quantgroup.tech.brave.configuration;

import cn.quantgroup.tech.brave.interceptor.*;
import cn.quantgroup.tech.brave.interceptor.impl.*;
import cn.quantgroup.tech.brave.job.TokenJob;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthAutoConfiguration {

    @Configuration
    public static class NoAuthConfiguration {

        @Bean
        @ConditionalOnMissingBean(HttpClientRequestInterceptor.class)
        public HttpClientRequestInterceptor httpClientRequestInterceptor() {
            return new HttpClientNoAuthRequestInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(OkHttpClientInterceptor.class)
        public OkHttpClientInterceptor okHttpClientInterceptor() {
            return new OkHttpClientNoAuthInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(RestTemplateRequestInterceptor.class)
        public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
            return new RestTemplateNoAuthRequestInterceptor();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix = "quant.auth", name = {"http", "clientId", "secret", "tokenUrl"})
    public static class AuthConfiguration {

        @Bean
        public HttpClientRequestInterceptor httpClientRequestInterceptor() {
            return new HttpClientAuthRequestInterceptor();
        }

        @Bean
        public OkHttpClientInterceptor okHttpClientInterceptor() {
            return new OkHttpClientAuthInterceptor();
        }

        @Bean
        public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
            return new RestTemplateAuthRequestInterceptor();
        }

        @Bean
        public TokenJob tokenJob() {
            return new TokenJob();
        }
    }
}
