package cn.quantgroup.boot;


import com.alibaba.cloud.nacos.registry.NacosAutoServiceRegistration;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;

@WebEndpoint(id = "serviceDeploy")
public class ServiceDeployEndpoint {

  final NacosAutoServiceRegistration nacosAutoServiceRegistration;

  public ServiceDeployEndpoint(NacosAutoServiceRegistration nacosAutoServiceRegistration) {
    this.nacosAutoServiceRegistration = nacosAutoServiceRegistration;
  }

  @ReadOperation
  public String offLine() {
    nacosAutoServiceRegistration.stop();
    return "ok";
  }

  @WriteOperation
  public String onLine() {
    nacosAutoServiceRegistration.start();
    return "ok";
  }
}