package cn.quantgroup.boot.apollo;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.internals.DefaultConfigManager;
import com.ctrip.framework.apollo.util.http.DefaultHttpClient;
import com.ctrip.framework.apollo.util.http.HttpRequest;
import com.ctrip.framework.apollo.util.http.HttpResponse;
import com.ctrip.framework.foundation.Foundation;
import lombok.ToString;
import org.slf4j.Logger;

import java.util.Map;
import java.util.Properties;

public class QGConfigManager extends DefaultConfigManager {

    private static final Logger log = DeferredLoggerFactory
            .getLogger(QGConfigManager.class);

    public QGConfigManager() {
        super();
        String env = Foundation.server().getEnvType();
        String idc = Foundation.server().getDataCenter();
        boolean isPro = Env.PRO.name().equalsIgnoreCase(env);
        if (isPro) {
            log.info("Env={} DataCenter={} Apollo 生产环境加载", env, idc);
            return;
        }
        String namespace = System.getProperty("NAMESPACE");
        if (namespace == null) {
            log.info("非生产环境需要配置 NAMESPACE");
            return;
        }
        String eosHost = System.getProperty("eos_server_host", "http://eos.quantgroups.com/");
        DefaultHttpClient httpClient = ApolloInjector.getInstance(DefaultHttpClient.class);
        HttpRequest httpRequest = new HttpRequest(eosHost + "api/apollo/env_vars?namespace=" + namespace);
        HttpResponse<KubeEnvInfo> mapHttpResponse = httpClient.doGet(httpRequest, KubeEnvInfo.class);
        KubeEnvInfo body = mapHttpResponse.getBody();
        if (body != null && body.success) {

            log.info("Env={} DataCenter={} Namespace={} Kubernetes 的环境变量已经注入, " +
                    "您可以放心的在 Kubernetes 之外启动你的服务了", env, idc, namespace);
            Properties properties = System.getProperties();
            properties.putAll(body.details);
            return;
        }
        log.error("Env={} DataCenter={} Namespace={} eos server 返回异常, serverInfo:{} ,body:{}",
                env, idc, namespace, eosHost, body);
    }


    @ToString
    private static class KubeEnvInfo {
        boolean success;
        Map<String, String> details;
    }
}
