package cn.quantgroup.tech.mq.service;

import cn.quantgroup.tech.mq.common.Constants;
import cn.quantgroup.tech.mq.entity.KoalaRabbitmqMessage;
import cn.quantgroup.tech.mq.enums.MOEnums;
import cn.quantgroup.tech.mq.mapper.KoalaRabbitmqMessageMapperV1;
import com.google.gson.Gson;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;

import javax.annotation.Resource;
import java.util.UUID;

public class MONotify {

    @Resource
    private RabbitTemplate moNotifyRabbitTemplate;
    @Resource
    private KoalaRabbitmqMessageMapperV1 koalaRabbitmqMessageMapperV1;

    public void send(MOEnums moEnums, String routingKey, final Object object) {
        String uniqueId = UUID.randomUUID().toString().replaceAll(Constants.CROSS, Constants.DEFAULT);
        Gson gson = new Gson();
        koalaRabbitmqMessageMapperV1.insert(KoalaRabbitmqMessage.builder()
                .uniqueId(uniqueId)
                .msgContent(gson.toJson(object))
                .exchange(Constants.MO_TTL_EXCHANGE)
                .routingKey(routingKey)
                .maxConsumeCount(Constants.DEFAULT_CONSUME_COUNT)
                .middleBusinessType(moEnums.getBusinessType())
                .build());
        CorrelationData correlationData = new CorrelationData(uniqueId);
        moNotifyRabbitTemplate.convertAndSend(Constants.MO_TTL_EXCHANGE, routingKey, object, correlationData);
    }
}
