package cn.quantgroup.tech.mq.config;

import cn.quantgroup.tech.mq.common.Constants;
import cn.quantgroup.tech.mq.enums.MOEnums;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

@Configuration
public class MOTTLConfiguration {

    @Bean
    public TopicExchange moTTLExchange() {
        return new TopicExchange(Constants.MO_TTL_EXCHANGE);
    }

    @Bean
    public TopicExchange moTTLDLXExchange() {
        return new TopicExchange(Constants.MO_TTL_DLX_EXCHANGE);
    }

    @Bean
    public Queue moTTLQueue() {
        Map<String, Object> agruments = new HashMap<>();
        agruments.put("x-dead-letter-exchange", Constants.MO_TTL_DLX_EXCHANGE);
        return new Queue(Constants.MO_TTL_QUEUE, true, false, false, agruments);
    }

    @Bean
    public Binding bindTTLQueueToTTLExchange() {
        return BindingBuilder.bind(moTTLQueue()).to(moTTLExchange()).with(Constants.MO_TTL_ROUTING_KEY);
    }

    /*---------- START EXCHANGE START ----------*/
    @Bean
    public TopicExchange moBlackHoleExchange() {
        return new TopicExchange(MOEnums.BLACK_HOLE.getExchange());
    }

    @Bean
    public TopicExchange moTradeExchange() {
        return new TopicExchange(MOEnums.TRADE.getExchange());
    }

    @Bean
    public TopicExchange moClothoExchange() {
        return new TopicExchange(MOEnums.CLOTHO.getExchange());
    }

    /*---------- END EXCHANGE END ----------*/

    /*---------- START BINDING START ----------*/
    @Bean
    public Binding bindBlackHoleExchangeToTTLDLXExchange() {
        return BindingBuilder.bind(moBlackHoleExchange()).to(moTTLDLXExchange()).with(MOEnums.BLACK_HOLE.getRoutingKey());
    }

    @Bean
    public Binding bindTradeExchangeToTTLDLXExchange() {
        return BindingBuilder.bind(moTradeExchange()).to(moTTLDLXExchange()).with(MOEnums.TRADE.getRoutingKey());
    }

    @Bean
    public Binding bindClothoExchangeToTTLDLXExchange() {
        return BindingBuilder.bind(moClothoExchange()).to(moTTLDLXExchange()).with(MOEnums.CLOTHO.getRoutingKey());
    }
    /*---------- END BINDING END ----------*/
}
