package cn.quantgroup.boot.tech.brave.service.impl;

import cn.quantgroup.boot.tech.brave.interceptor.HttpClientRequestInterceptor;
import cn.quantgroup.boot.tech.brave.service.ITechHttpClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.impl.client.HttpClientBuilder;

import javax.annotation.Resource;

/**
 * @author zhangheng
 * create on 2018.05.17
 */
@Slf4j
public class TechHttpClientNoTrace implements ITechHttpClient {

    @Resource
    private HttpClientRequestInterceptor httpClientRequestInterceptor;

    @Override
    public HttpClientBuilder createHttpClientBuilder() {
        log.info("构建HttpClientBuilder");
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.addInterceptorFirst(httpClientRequestInterceptor);
        return httpClientBuilder;
    }
}
