package cn.quantgroup.boot.tech.enoch.agent;

import cn.quantgroup.boot.tech.enoch.agent.report.IAgentReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author: amen
 * @date: 2019-02-26
 */
@Lazy
@Component
@EnableScheduling
public class AgentReportTask {

    @Autowired
    private IAgentReportService reportService;

    /**
     * 1毫秒采集一次数据
     */
    @Scheduled(fixedRate = 1000)
    public void collect() {
        reportService.collect();
    }

    /**
     * 1毫秒上报一次数据
     */
    @Scheduled(fixedRate = 1000)
    public void report() {
        reportService.report();
    }

}