package cn.quantgroup.tech.brave.service.impl;

import cn.quantgroup.tech.brave.interceptor.RestTemplateRequestInterceptor;
import cn.quantgroup.tech.brave.service.ITechRestTemplateBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangheng
 * create on 2018.05.17
 */
@Slf4j
public class TechRestTemplateBuliderNoTrace implements ITechRestTemplateBuilder {
    @Resource
    private RestTemplateRequestInterceptor restTemplateRequestInterceptor;

    @Override
    public RestTemplate createRestTemplate() {
        log.info("构建RestTemplate");
        RestTemplate restTemplate = new RestTemplate();
        List<ClientHttpRequestInterceptor> interceptors = new ArrayList<>(restTemplate.getInterceptors());
        interceptors.add(restTemplateRequestInterceptor);
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }
}
