package cn.quantgroup.tech.autoconfigure;

import cn.quantgroup.tech.endpoint.HealthCheckMvcEndpoint;
import cn.quantgroup.tech.shutdown.DefaultSignalHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import sun.misc.Signal;

/**
 * @author jinsong.zhu
 * @date 2017/12/18
 */
@Slf4j
@Configuration
@AutoConfigureAfter({FlywayAutoConfiguration.class, LiquibaseAutoConfiguration.class})
@EnableConfigurationProperties(EndpointProperties.class)
public class TechCommonAutoConfiguration {

    ConfigurableApplicationContext applicationContext;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = (ConfigurableApplicationContext) applicationContext;
        initSignalHandler(this.applicationContext);
    }

    private void initSignalHandler(ConfigurableApplicationContext applicationContext) {
        log.info("starting init graceful shutdown by listening on int signal .");
        Signal.handle(new Signal("INT"), new DefaultSignalHandler(applicationContext));
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthCheckMvcEndpoint healthCheckMvcEndpoint() {
        return new HealthCheckMvcEndpoint();
    }
}