package cn.quantgroup.tech.endpoint;

import cn.quantgroup.tech.web.dto.Result;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author jinsong.zhu
 * @date 2017/12/18
 */
@ConfigurationProperties(prefix = "endpoints.qg.health")
public class HealthCheckMvcEndpoint implements MvcEndpoint {

    public HealthCheckMvcEndpoint() {
    }

    @RequestMapping(value = "check", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result check() {
        return Result.ok();
    }

    @Override
    public String getPath() {
        return "/health";
    }

    @Override
    public boolean isSensitive() {
        return false;
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }

}
