package cn.quantgroup.tech.security;

import org.springframework.security.authentication.AbstractAuthenticationToken;

/**
 * @author jinsong.zhu
 * @date 2018/1/17
 */
public class ZuulAuthentication extends AbstractAuthenticationToken {

    private static final long serialVersionUID = -4809832298438307319L;

    private final ZUser user;

    public ZuulAuthentication(ZUser user) {
        super(user.getAuthorities());
        this.user = user;
    }

    @Override
    public Object getCredentials() {
        return "";
    }

    @Override
    public Object getPrincipal() {
        return user;
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public void eraseCredentials() {
        super.eraseCredentials();
    }

}
