package cn.quantgroup.boot.tech.brave.interceptor.impl;

import cn.quantgroup.boot.tech.brave.handler.TokenHandler;
import cn.quantgroup.boot.tech.brave.interceptor.RequestInterceptor;
import cn.quantgroup.boot.tech.brave.interceptor.RestTemplateRequestInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;

import java.io.IOException;

@Slf4j
public class RestTemplateAuthRequestInterceptor extends RequestInterceptor implements RestTemplateRequestInterceptor {

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution)
            throws IOException {
        if (auth(request.getURI().getHost())) {
            log.info("cn.quantgroup.tech.brave.interceptor.RestTemplateRequestInterceptor.intercept token = 【{}】 ", TokenHandler.getToken());
            request.getHeaders().add(AUTH, TokenHandler.getToken());
        }
        return execution.execute(request, body);
    }
}
