package cn.quantgroup.tech.brave.interceptor;

import cn.quantgroup.tech.brave.interceptor.job.TokenJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

import java.io.IOException;

@Slf4j
@Component
public class RestTemplateRequestInterceptor extends RequestInterceptor implements ClientHttpRequestInterceptor {

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution)
            throws IOException {
        if (auth(request.getURI().getHost())) {
            log.info("cn.quantgroup.tech.brave.interceptor.RestTemplateRequestInterceptor.intercept token = 【{}】 ", TokenJob.token);
            request.getHeaders().add(AUTH, TokenJob.token);
        }
        return execution.execute(request, body);
    }
}
