package cn.quantgroup.tech.brave.interceptor;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

@Slf4j
public abstract class RequestInterceptor {

    static final String AUTH = "quant-auth";
    // 内网
    @Value("#{'${quant.auth.http}'.split(',')}")
    List<String> authHttpList;

    boolean auth(String host) {
        if (authHttpList == null || authHttpList.isEmpty()) {
            return false;
        }
        return authHttpList.stream()
                .map(http -> {
                    URL url = null;
                    try {
                        url = new URL(http);
                    } catch (MalformedURLException e) {
                        log.error("无效quant.auth.http = 【{}】", http);
                    }
                    return Optional.ofNullable(url);
                })
                .filter(Optional::isPresent)
                .anyMatch(url -> url.get().getHost().equals(host));
    }
}
