package cn.quantgroup.tech.brave.interceptor;

import cn.quantgroup.tech.brave.interceptor.job.TokenJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class HttpClientRequestInterceptor extends RequestInterceptor implements HttpRequestInterceptor {

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        if (auth(((HttpRequestWrapper) httpRequest).getTarget().getHostName())) {
            log.info("cn.quantgroup.tech.brave.interceptor.HttpClientRequestInterceptor.process token = 【{}】 ", TokenJob.token);
            httpRequest.addHeader(AUTH, TokenJob.token);
        }
    }
}
