package cn.quantgroup.tech.util;

import com.ctrip.framework.foundation.Foundation;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class TechEnvironment {

    private volatile static TechEnvironment instance;

    private boolean pro = false;
    private String env;

    private TechEnvironment() {
        String envType = Foundation.server().getEnvType();
        env = envType;
        if (envType.equals("pro")) {
            pro = true;
        }
    }

    private static TechEnvironment getInstance() {
        if (instance == null) {
            synchronized (TechEnvironment.class) {
                if (instance == null) {
                    instance = new TechEnvironment();
                }
            }
        }
        return instance;
    }

    public static String getEnv() {
        return getInstance().env;
    }

    public static boolean isPro() {
        return getInstance().pro;
    }

}
