package cn.quantgroup.tech.web.dto;

/**
 * 自定义请求状态码
 *
 * @author zero-mac
 * @date 16/6/17
 */
public enum ResultStatus {

    INIT(0, ""),
    SUCCESS(200, ""),

    FEIGN_REQUEST_FAILED(404, "服务端未响应."),

    REQUEST_VALIDATE_ERROR(400, "请求无效(Bad request),参数异常"),

    // 由开发人员出现严重bug造成的异常
    SERVER_ERROR(500, "开发状态--严重异常,程序无法正常运行,请开发人员检查问题"),

    // 由开发人员代码不严谨造成的异常, 如未进行判空处理等,导致未能返回贴合业务的提示信息
    RUNTIME_SERVER_ERROR(502, "运行状态--异常通知,请开发人员检查问题并作出正确提示"),

    // 数据处理异常提醒, 包括传入数据不正确等, 异常由框架发起
    FRAME_SERVER_ERROR(504, "运行状态--异常通知,请框架维护人员检查问题并作出正确提示"),

    // 数据处理异常提醒, 包括传入数据不正确等, 异常由开发人员发起
    APPLICATION_SERVER_ERROR(506, "运行状态--异常通知,请开发人员检查问题并作出正确提示"),
    //
    ;

    /**
     * 返回码
     */
    private int code;

    /**
     * 返回结果描述
     */
    private String message;

    ResultStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
