package cn.quantgroup.tech.brave.service.impl;

import brave.Tracing;
import brave.spring.rabbit.SpringRabbitTracing;
import cn.quantgroup.tech.brave.service.ITechRabbitBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
@Slf4j
public class TechRabbitBuilderTrace implements ITechRabbitBuilder {
    private SpringRabbitTracing.Builder springRabbitTracingBuilder;

    public TechRabbitBuilderTrace(Tracing tracing) {
        springRabbitTracingBuilder = SpringRabbitTracing.newBuilder(tracing);
    }

    @Override
    public RabbitTemplate createRabbitTemplate(ConnectionFactory connectionFactory) {
        log.info("构建brave-RabbitTemplate");
        String virtualHost = connectionFactory.getVirtualHost();
        SpringRabbitTracing.Builder builder = springRabbitTracingBuilder.remoteServiceName("MQ-" + virtualHost);
        return builder.build().newRabbitTemplate(connectionFactory);
    }

    @Override
    public SimpleRabbitListenerContainerFactory createSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        log.info("构建brave-SimpleRabbitListenerContainerFactory");
        String virtualHost = connectionFactory.getVirtualHost();
        SpringRabbitTracing.Builder builder = springRabbitTracingBuilder.remoteServiceName("MQ-" + virtualHost);
        return builder.build().newSimpleRabbitListenerContainerFactory(connectionFactory);
    }
}
