package cn.quantgroup.tech.brave.service.impl;

import brave.propagation.CurrentTraceContext;
import cn.quantgroup.tech.brave.service.ITechExecutorServiceBuilder;
import cn.quantgroup.tech.brave.slf4j.MDCCurrentTraceContext;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.ExecutorService;

/**
 * zipkin线程池追踪一致性
 * Date: 2020/1/6
 * Time: 下午4:52
 *
 * @author: yangrui
 */
@Slf4j
public class TechExecutorServiceBuilderTrace implements ITechExecutorServiceBuilder {
    @Override
    public ExecutorService buildExecutorService(ExecutorService executorService) {
        log.info("构建ExecutorServiceTrace");
        CurrentTraceContext mdcCurrentTraceContext = MDCCurrentTraceContext.create();
        return mdcCurrentTraceContext.executorService(executorService);
    }
}
