package cn.quantgroup.tech.shutdown;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.config.RabbitListenerConfigUtils;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PreDestroy;

/**
 * 这里是一些基本的停止工具.  to be continue
 *
 * @author ag
 */
@Slf4j
@Configuration
public class BaseDestroyHandler {

    @Autowired
    private ApplicationContext applicationContext;

    @PreDestroy
    private void stopRedisSub() {
        log.info("我什么都没做, redis stopped");
    }

    @PreDestroy
    private void stopRabbitMQ() {
        try {
            RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry = applicationContext.getBean(
                    RabbitListenerConfigUtils.RABBIT_LISTENER_ENDPOINT_REGISTRY_BEAN_NAME,
                    RabbitListenerEndpointRegistry.class);
            rabbitListenerEndpointRegistry.getListenerContainers().forEach(Lifecycle::stop);
        } catch (Exception e) {
            //貌似这段日志不会打印...
            log.error("貌似停止 MQ 遇到了问题... 你有MQ么? ");
        }
        log.info("MQ listener stopped");
    }
}
