package cn.quantgroup.tech.security;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * @author jinsong.zhu
 * @date 2018/1/17
 */
public class SecurityUtil {


    public static ZUser extractHeader(HttpServletRequest request) {
        // valid secret.
        String secret = request.getHeader(ZUser.HEADER_SECRET_KEY_FROM_GATEWAY);
        if (StringUtils.isEmpty(secret) || !secret.equals(ZUser.HEADER_SECRET_VAL_FROM_GATEWAY)) {
            return null;
        }

        String uuid = request.getHeader(ZUser.HEADER_UUID);
        if (StringUtils.isNotEmpty(uuid)) {
            String userIdStr = request.getHeader(ZUser.HEADER_USER_ID);
            Long userId = parseLong(userIdStr);
            if (userId == null) {
                // ignore.
                return null;
            }
            String phoneNo = request.getHeader(ZUser.HEADER_PHONE_NO);
            if (StringUtils.isEmpty(phoneNo)) {
                // ignore.
                return null;
            }
            ZUser user = new ZUser(uuid, userId, phoneNo);
            return user;
        }
        return null;
    }

    public static Long parseLong(String str) {
        return parseLong(str, null);
    }

    public static Long parseLong(String str, Long defaultValue) {
        try {
            return Long.parseLong(str);
        } catch (Exception e) {
            return defaultValue;
        }
    }
}
