package cn.quantgroup.tech.enoch.agent.report.impl;

import cn.quantgroup.tech.enoch.agent.configuration.EnochAgentProperties;
import cn.quantgroup.tech.enoch.agent.report.IReportService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.EnvironmentMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HealthMvcEndpoint;
import org.springframework.boot.actuate.health.Health;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;

/**
 * @author: amen
 * @date: 2019-02-26
 */
@Slf4j
@Service
public class ReportServiceImpl implements IReportService {

    @Autowired
    private HealthEndpoint healthEndpoint;

    @Autowired
    private HealthMvcEndpoint healthMvcEndpoint;

    @Autowired
    private MetricsEndpoint metricsEndpoint;

    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;

    @Autowired
    private EnochAgentProperties enochAgentProperties;

    @Autowired
    private EnvironmentMvcEndpoint environmentMvcEndpoint;

    private final ArrayBlockingQueue<Map<String, Object>> arrayBlockingQueue = new ArrayBlockingQueue<>(600);

    private final ApplicationInfo applicationInfo = new ApplicationInfo();

    @Override
    public void report() {
        int size = arrayBlockingQueue.size();
        if (size <= 0) {
            return;
        }
        List<Map<String, Object>> slice = new ArrayList<>(size);
        arrayBlockingQueue.drainTo(slice, size);
        Map<String, Object> pushPackage = new HashMap<>(6);
        if (StringUtils.isBlank(applicationInfo.getAppName())) {
            initApplicationInfo();
        }
        pushPackage.put("ip", applicationInfo.getIp());
        pushPackage.put("appName", applicationInfo.getAppName());
        pushPackage.put("endPoints", slice);
        //todo 若发kafka失败，添加本地持久化操作，待下次提交时，一同push
        kafkaTemplate.send(enochAgentProperties.getKafkaTopic(), JSON.toJSONString(pushPackage, SerializerFeature.DisableCircularReferenceDetect));
    }

    @Override
    public void collect() {
        HashMap<String, Object> endPoints = new HashMap<>(16);
        Health health = healthMvcEndpoint.getDelegate().invoke();
        Health.status(health.getStatus()).build();
        endPoints.put("health", health);
        endPoints.put("metrics", metricsEndpoint.invoke());
        endPoints.put("timestamp", System.nanoTime());
        try {
            arrayBlockingQueue.put(endPoints);
        } catch (InterruptedException e) {
            log.error("enoch.agent collect data error: {}", e);
        }
    }

    private ApplicationInfo initApplicationInfo() {
        Map<String, String> appName = (HashMap) environmentMvcEndpoint.value("spring.application.name");
        Map<String, String> ip = (HashMap) environmentMvcEndpoint.value("spring.cloud.client.ipAddress");
        applicationInfo.setAppName(appName.get("spring.application.name"));
        applicationInfo.setIp(ip.get("spring.cloud.client.ipAddress"));
        return applicationInfo;
    }

    @Data
    public static class ApplicationInfo {
        private String ip;
        private String appName;
    }
}
