package cn.quantgroup.tech.enoch.agent.configuration;

import cn.quantgroup.tech.enoch.agent.AgentReportTask;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

import java.util.HashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * @author: amen
 * @date: 2019-02-26
 */
@Slf4j
@Configuration
@ComponentScan(basePackageClasses = {AgentReportTask.class})
@EnableConfigurationProperties(EnochAgentProperties.class)
public class EnochAgentAutoConfiguration {

    @Autowired
    private EnochAgentProperties enochAgentProperties;

    @Bean
    public ProducerFactory<String, String> producerFactory() {
        HashMap<String, Object> config = new HashMap<>(16);
        config.put(ProducerConfig.BOOTSTRAP_SERVERS_CONFIG, enochAgentProperties.getKafkaHost());
        config.put(ProducerConfig.KEY_SERIALIZER_CLASS_CONFIG, StringSerializer.class);
        config.put(ProducerConfig.VALUE_SERIALIZER_CLASS_CONFIG, StringSerializer.class);
        return new DefaultKafkaProducerFactory(config);
    }

    @Bean
    @ConditionalOnBean(ProducerFactory.class)
    public KafkaTemplate<String, String> kafkaTemplate(ProducerFactory<String, String> producerFactory) {
        return new KafkaTemplate<>(producerFactory);
    }


    @Configuration
    public static class ScheduleConfig implements SchedulingConfigurer {
        @Override
        public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2);
            taskRegistrar.setScheduler(executor);
        }
    }

}