package cn.quantgroup.tech.enoch.agent;

import cn.quantgroup.tech.enoch.agent.report.IReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author: amen
 * @date: 2019-02-26
 */
@Component
@EnableScheduling
public class AgentReportTask {

    @Autowired
    private IReportService reportService;

    /**
     * 1毫秒采集一次数据
     */
    @Scheduled(fixedRate = 1000)
    public void collect() {
        reportService.collect();
    }

    /**
     * 1毫秒上报一次数据
     */
    @Scheduled(fixedRate = 1000)
    public void report() {
        reportService.report();
    }
}