package cn.quantgroup.tech.shutdown;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PreDestroy;

/**
 * 这里是一些基本的停止工具.  to be continue
 *
 * @author ag
 */
@Slf4j
@Configuration
public class BaseDestroyHandler {

    @Autowired
    private ApplicationContext applicationContext;

    @PreDestroy
    private void stopRedisSub() {
        log.info("我什么都没做, redis stopped");
    }

    @PreDestroy
    private void stopRabbitMQ() {
        log.info("MQ listener stopped");
    }
}
