package cn.quantgroup.apollopatch.spring;

import com.ctrip.framework.foundation.Foundation;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.core.Ordered;

public class QGSpringApplicationRunListener implements SpringApplicationRunListener, Ordered
{

    private final SpringApplication application;
    private final String[] args;

    public QGSpringApplicationRunListener(SpringApplication application, String[] args) {
        this.application = application;
        this.args = args;
        System.setProperty("apollo.bootstrap.enabled", "true");
        String property = Foundation.app().getProperty("namespace", "application");
        System.setProperty("apollo.bootstrap.namespaces", property);
        System.setProperty("apollo.bootstrap.eagerLoad.enabled", "true");
    }


    @Override
    public int getOrder() {
        return 0;
    }
}
