package cn.quantgroup.tech.brave.annotation;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Aspect
@Component
public class DynamicTraceAspect {

    @Resource
    private Tracing tracing;

    @Around("@annotation(cn.quantgroup.tech.brave.annotation.DynamicTrace)")
    public Object dynamicTrace(ProceedingJoinPoint pjp) throws Throwable {
        Tracer tracer = tracing.tracer();
        /* 防止应用层非法使用（上下文中存在span），不生成root span。 */
        if (tracer.currentSpan() == null) {
            Span span = tracer.newTrace();
            try (Tracer.SpanInScope ws = tracer.withSpanInScope(span)) {
                return pjp.proceed();
                // note: try-with-resources closes the scope *before* the catch block
            } catch (RuntimeException | Error e) {
                span.error(e);
                throw e;
            } finally {
                span.finish();
            }
        }
        return pjp.proceed();
    }

}
