package cn.quantgroup.tech.brave.service.impl;

import brave.spring.web.TracingClientHttpRequestInterceptor;
import cn.quantgroup.tech.brave.service.ITechRestTemplateBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangheng
 * create on 2018.05.17
 */
@Slf4j
@Import( TracingClientHttpRequestInterceptor.class )
public class TechRestTemplateBuilderTrace implements ITechRestTemplateBuilder {
    @Autowired
    private TracingClientHttpRequestInterceptor clientInterceptor;

    @Override
    public RestTemplate createRestTemplate() {
        log.info("构建brave-RestTemplate拦截器");
        RestTemplate restTemplate = new RestTemplate();
        List<ClientHttpRequestInterceptor> interceptors = new ArrayList<>(restTemplate.getInterceptors());
        interceptors.add(clientInterceptor);
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }
}
