package cn.quantgroup.tech.brave.service;

import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
public class TechRabbitBuilderNoTrace implements ITechRabbitBuilder {
    public TechRabbitBuilderNoTrace() {
    }

    @Override
    public RabbitTemplate createRabbitTemplate(ConnectionFactory connectionFactory) {
        return new RabbitTemplate(connectionFactory);
    }

    @Override
    public SimpleRabbitListenerContainerFactory createSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        return factory;
    }
}
