package cn.quantgroup.tech.security;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Arrays;
import java.util.Collection;

/**
 * 登录用户模型.
 * <p>
 * @author jinsong.zhu
 * @date 2018/1/17
 */
@Data
@NoArgsConstructor
public class ZUser implements UserDetails {

    public static final String DEFAULT_PASS = "";
    public static final String HEADER_USER_ID = "z-user-id";
    public static final String HEADER_UUID = "z-user-uuid";
    public static final String HEADER_PHONE_NO = "z-user-phone-no";
    public static final String HEADER_SECRET_KEY_FROM_GATEWAY = "z-user-secret";
    public static final String HEADER_SECRET_VAL_FROM_GATEWAY = "z.h,w44RXMu4XL#dq_%@ZX,u*gd]zVhmdks@H8krq*Gn-CC:6>YTHX_Kh=_#D7LR";

    private String uuid;
    private Long userId;
    private String phoneNo;

    public ZUser(String uuid, Long userId, String phoneNo) {
        this.uuid = uuid;
        this.userId = userId;
        this.phoneNo = phoneNo;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Arrays.asList(new SimpleGrantedAuthority("ROLE_USER"));
    }

    @Override
    public String getPassword() {
        return DEFAULT_PASS;
    }

    @Override
    public String getUsername() {
        return null;
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.uuid != null;
    }
}
