package cn.quantgroup.xyqb.Util;

import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

import java.util.Arrays;

/**
 * Created by zhiguo.liu on 2017/7/28.
 */
public class RedisUtils {
    /**
     * 通过 setnx + expire 命令，原子性给某个 key 上锁并设置过期时间
     * 上锁成功返回 true ，上锁失败返回 false.
     *
     * @param redisTemplate
     * @param key
     * @param expire
     * @return
     */

    public static boolean lock(RedisTemplate redisTemplate, String key, Integer expire) {
        String lua = "local result = redis.call(\"setnx\",KEYS[1],\"1\")if result == 1 then redis.call(\"expire\",KEYS[1],ARGV[1]) end return result";
        RedisScript<Long> script = new DefaultRedisScript<>(lua, Long.class);

        Object result = redisTemplate.execute(script, Arrays.asList(key), expire.toString());
        if (result != null && result instanceof Long) {
            return (Long) result == 1;
        }
        return false;
    }

}
