package cn.quantgroup.tech.brave.service;

import brave.Tracing;
import brave.spring.rabbit.SpringRabbitTracing;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
public class TechRabbitBuilderTrace implements ITechRabbitBuilder {
    private SpringRabbitTracing.Builder springRabbitTracingBuilder;

    public TechRabbitBuilderTrace(Tracing tracing){
        springRabbitTracingBuilder = SpringRabbitTracing.newBuilder(tracing);
    }

    @Override
    public ITechRabbitBuilder remoteServiceName(String remoteServiceName) {
        springRabbitTracingBuilder.remoteServiceName(remoteServiceName);
        return this;
    }

    @Override
    public RabbitTemplate crateRabbitTemplate(ConnectionFactory connectionFactory) {
        return springRabbitTracingBuilder.build().newRabbitTemplate(connectionFactory);
    }

    @Override
    public SimpleRabbitListenerContainerFactory createSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        return springRabbitTracingBuilder.build().newSimpleRabbitListenerContainerFactory(connectionFactory);
    }
}
