package cn.quantgroup.tech.security;

import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 对header中的key进行处理,如果包含用户标识,则处理放入SecurityContext中.
 *
 * @author jinsong.zhu
 * @date 2018/1/16
 */
@Slf4j
public class AuthenticationByGatewayProcessingFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // do nothing.
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest request = (HttpServletRequest) req;

        ZUser user = TechSecurityUtil.extractHeader(request);
        if (user == null) {
            // clear context to remove user.
            SecurityContextHolder.clearContext();
        } else {
            Authentication authResult = new ZuulAuthentication(user);
            SecurityContextHolder.getContext().setAuthentication(authResult);
        }

        chain.doFilter(req, res);
    }

    @Override
    public void destroy() {
        // do nothing.
    }

}
