package cn.quantgroup.tech.brave.configuration;

import cn.quantgroup.tech.brave.interceptor.*;
import cn.quantgroup.tech.brave.interceptor.impl.*;
import cn.quantgroup.tech.brave.job.TokenJob;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthAutoConfiguration {

    @Configuration
    public static class NoAuthConfiguration {

        @Bean
        @ConditionalOnMissingBean(HttpClientRequestInterceptor.class)
        public HttpClientRequestInterceptor httpClientRequestInterceptor() {
            return new HttpClientNoAuthRequestInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(OkHttpClientInterceptor.class)
        public OkHttpClientInterceptor okHttpClientInterceptor() {
            return new OkHttpClientNoAuthInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(RestTemplateRequestInterceptor.class)
        public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
            return new RestTemplateNoAuthRequestInterceptor();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix = "tech.auth", name = "enabled", havingValue = "true")
    public static class AuthConfiguration {

        @Bean
        @ConditionalOnProperty(prefix = "tech.auth", name = {"http", "clientId", "secret", "tokenUrl"})
        public HttpClientRequestInterceptor httpClientRequestInterceptor() {
            return new HttpClientAuthRequestInterceptor();
        }

        @Bean
        @ConditionalOnProperty(prefix = "tech.auth", name = {"http", "clientId", "secret", "tokenUrl"})
        public OkHttpClientInterceptor okHttpClientInterceptor() {
            return new OkHttpClientAuthInterceptor();
        }

        @Bean
        @ConditionalOnProperty(prefix = "tech.auth", name = {"http", "clientId", "secret", "tokenUrl"})
        public RestTemplateRequestInterceptor restTemplateRequestInterceptor() {
            return new RestTemplateAuthRequestInterceptor();
        }

        @Bean
        @ConditionalOnProperty(prefix = "tech.auth", name = {"http", "clientId", "secret", "tokenUrl"})
        public TokenJob tokenJob() {
            return new TokenJob();
        }
    }
}
