package cn.quantgroup.tech.brave.aspect;

import brave.Tracer;
import brave.Tracing;
import com.dangdang.ddframe.job.api.ElasticJob;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

@Aspect
@Configuration
@ConditionalOnClass(ElasticJob.class)
@ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "true", matchIfMissing = true)
public class ElasticJobAspect {

    @Resource
    private Tracing tracing;

    @Around("target(com.dangdang.ddframe.job.api.ElasticJob)")
    public Object dynamicTrace(ProceedingJoinPoint pjp) throws Throwable {
        Tracer tracer = tracing.tracer();
        /* 防止应用层非法使用（上下文中存在span），不生成root span。 */
        if (tracer.currentSpan() == null) {
            brave.Span span = tracer.newTrace();
            try (Tracer.SpanInScope ws = tracer.withSpanInScope(span)) {
                return pjp.proceed();
                // note: try-with-resources closes the scope *before* the catch block
            } catch (RuntimeException | Error e) {
                span.error(e);
                throw e;
            } finally {
                span.finish();
            }
        }
        return pjp.proceed();
    }
}
