package cn.quantgroup.tech.autoconfigure;

import cn.quantgroup.tech.endpoint.HealthCheckMvcEndpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author jinsong.zhu
 * @date 2017/12/18
 */
@Configuration
@AutoConfigureAfter({FlywayAutoConfiguration.class, LiquibaseAutoConfiguration.class})
@EnableConfigurationProperties(EndpointProperties.class)
public class EndpointAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public HealthCheckMvcEndpoint healthCheckMvcEndpoint() {
        return new HealthCheckMvcEndpoint();
    }
}