package cn.quantgroup.tech.security;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * 获取当前登录用户.
 *
 * @author jinsong.zhu
 * @date 2018/1/17
 */
public class TechSecurityContext {

    /**
     * try to get user from security context.
     *
     * @return return null if has no authenticated user.
     */
    public static final ZUser getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object principal = authentication.getPrincipal();
        if (principal instanceof ZUser) {
            ZUser user = (ZUser) principal;
            return user;
        }
        return null;
    }

    public static final Long getUserId() {
        ZUser user = getUser();
        if (user == null) {
            return null;
        }
        return user.getUserId();
    }

    public static final String getUserPhoneNo() {
        ZUser user = getUser();
        if (user == null) {
            return null;
        }
        return user.getPhoneNo();
    }

    public static final String getUserUuid() {
        ZUser user = getUser();
        if (user == null) {
            return null;
        }
        return user.getUuid();
    }

}
