package cn.quantgroup.tech.brave.service;

import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
public class SpringRabbit {

    public static SpringRabbit create() {
        return new SpringRabbit.Builder().build();
    }

    public static SpringRabbit.Builder newBuilder() {
        return new SpringRabbit.Builder();
    }

    public static final class Builder {
        String remoteServiceName = "rabbitmq";

        Builder() {
        }

        /**
         * The remote service name that describes the broker in the dependency graph. Defaults to
         * "rabbitmq"
         */
        public SpringRabbit.Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public SpringRabbit build() {
            return new SpringRabbit(this);
        }
    }

    SpringRabbit(SpringRabbit.Builder builder) { // intentionally hidden constructor
        String remoteServiceName = builder.remoteServiceName;
    }

    /**
     * Creates an instrumented {@linkplain RabbitTemplate}
     */
    public RabbitTemplate newRabbitTemplate(ConnectionFactory connectionFactory) {
        return new RabbitTemplate(connectionFactory);
    }

}
