package cn.quantgroup.tech.brave.service;

import brave.Tracing;
import brave.spring.rabbit.SpringRabbitTracing;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
public class RabbitTemplateBuilderTrace implements IRabbitTemplateBuilder{
    private SpringRabbitTracing.Builder springRabbitTracingBuilder;

    public RabbitTemplateBuilderTrace (Tracing tracing){
        springRabbitTracingBuilder = SpringRabbitTracing.newBuilder(tracing);
    }

    @Override
    public IRabbitTemplateBuilder remoteServiceName(String remoteServiceName) {
        springRabbitTracingBuilder.remoteServiceName(remoteServiceName);
        return this;
    }

    @Override
    public RabbitTemplate build(ConnectionFactory connectionFactory) {
        return springRabbitTracingBuilder.build().newRabbitTemplate(connectionFactory);
    }
}
