package cn.quantgroup.tech.brave.service;

import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
public class RabbitTemplateBuilderNoTrace implements IRabbitTemplateBuilder{
    private SpringRabbit.Builder springRabbitBuilder;

    public RabbitTemplateBuilderNoTrace(){
        springRabbitBuilder = SpringRabbit.newBuilder();
    }
    @Override
    public IRabbitTemplateBuilder remoteServiceName(String remoteServiceName) {
        springRabbitBuilder.remoteServiceName(remoteServiceName);
        return this;
    }

    @Override
    public RabbitTemplate build(ConnectionFactory connectionFactory) {
        return springRabbitBuilder.build().newRabbitTemplate(connectionFactory);
    }
}
