package cn.quantgroup.tech.shutdown.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Global graceful shutdown properties.
 *
 * @author Corentin Azelart
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "shutdown.graceful")
public class GracefulShutdownProperties {

    /**
     * The timeout before force shutdown. TimeUnit.Second
     */
    private Integer timeout = 10;
}
