package cn.quantgroup.tech.brave.service.impl;

import cn.quantgroup.tech.brave.service.ITechExecutorServiceBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;

/**
 * Date: 2020/1/6
 * Time: 下午4:52
 *
 * @author: yangrui
 */
@Slf4j
public class TechExecutorServiceBuilderNoTrace implements ITechExecutorServiceBuilder {
    @Override
    public ExecutorService buildExecutorService(int corePoolSize,
                                                int maxPoolSize,
                                                int queueCapacity,
                                                String threadNamePrefix,
                                                RejectedExecutionHandler rejectedExecutionHandler) {
        log.info("构建TechExecutorServiceBuilderNoTrace, corePoolSize = 【{}】, maxPoolSize = 【{}】, queueCapacity = 【{}】, " +
                        "threadNamePrefix = 【{}】, rejectedExecutionHandler = 【{}】", corePoolSize, maxPoolSize, queueCapacity,
                threadNamePrefix, rejectedExecutionHandler);
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setThreadNamePrefix(threadNamePrefix);
        executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        executor.initialize();
        return executor.getThreadPoolExecutor();
    }
}
