package cn.quantgroup.tech.brave.service.impl;

import brave.propagation.CurrentTraceContext;
import cn.quantgroup.tech.brave.service.ITechExecutorServiceBuilder;
import cn.quantgroup.tech.brave.slf4j.MDCCurrentTraceContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;

/**
 * Date: 2020/1/6
 * Time: 下午4:52
 *
 * @author: yangrui
 */
public class ITechExecutorServiceBuilderTrace implements ITechExecutorServiceBuilder {
    @Override
    public ExecutorService buildExecutorService(int corePoolSize,
                                                int maxPoolSize,
                                                int queueCapacity,
                                                String threadNamePrefix,
                                                RejectedExecutionHandler rejectedExecutionHandler) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setThreadNamePrefix(threadNamePrefix);
        executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        executor.initialize();
        CurrentTraceContext mdcCurrentTraceContext = MDCCurrentTraceContext.create();
        return mdcCurrentTraceContext.executorService(executor.getThreadPoolExecutor());
    }
}
